﻿//
//	actor object class
//
//	TEMPLATE: This is an example of a constructable object class...
//		and we often do this "actor" thing, so it's a good starting point.
//

rat.modules.add( "js.actor",
[
	//	dependencies...
	{name:"js.app", processBefore:true},
	//{name:"js.game", processBefore:true},
	
],
function(rat)
{
	//	constructor
	var Actor = function()
	{
		this.pos = {x:500, y:500};
		this.rot = 0;
	};
	
	//	update with deltatime
	Actor.prototype.update = function(dt)
	{
		var dx = (Math.random() - 0.5) * 400 * dt;
		var dy = (Math.random() - 0.5) * 400 * dt;
		this.pos.x += dx;
		this.pos.y += dy;
		
		this.rot += dt * 2;
	};
	
	//	draw
	Actor.prototype.draw = function(ctx)
	{
		//	maybe ask gfx module to draw us?
		//	in the mean time...
		ctx.save();
		ctx.translate(this.pos.x, this.pos.y);
		ctx.fillStyle = "#FFFF00";
		var size = 100;
		ctx.fillRect(-size/2, -size/2, size, size);
		ctx.fillStyle = "#606000";
		ctx.lineWidth = 4;
		ctx.strokeRect(-size/2, -size/2, size, size);
		ctx.restore();
	};
	
	//	accessible outside this module
	app.types.Actor = Actor;
	
});
