﻿//
//	Game specific audio
//
//	Here's the list of sounds that we register with the rat audio system,
//	and some related support functions.
//
rat.modules.add( "js.audio",
[
	"rat.audio.r_audio",
],
function(rat)
{
	var audio = {

		init : function()
		{
			//	load sounds.  Can just list the resource (in which case id is filename) or explicitly specify ID.
			
			rat.audio.loadSounds([
				
				{id:'click', resource:"audio/click.mp3", volume:0.8},
				
				[	//	list several, audio system will randomly pick one
					{id:'hit', resource:"audio/hit.mp3", volume:0.6},
					{id:'hit', resource:"audio/thunk.mp3", volume:0.6},
				],
				
				{id:'rumble', resource:"audio/low_rumble.mp3", volume:0.7},
				
				{id:'music', resource:"audio/music.mp3", volume:0.2},
				
			]);
			
			rat.ui.Button.defaultClickSound = 'click';
		},

		playSound : function(soundID)
		{
			//	special case...  since rat audio system only supports one on/off switch right now,
			//	we need to override it.  :)
			if (soundID == 'music')
			{
				var oldOnOff = rat.audio.soundOn;
				rat.audio.soundOn = true;
				rat.audio.playSound(soundID);
				rat.audio.soundOn = rat.audio.soundOn;
			} else
				rat.audio.playSound(soundID);
		},
		
		stopSound : function(soundID)
		{
			rat.audio.stopSound(soundID);
		},
		
		musicIsPlaying : false,	//	at launch, before we've even read prefs, music is always off.
		visibility : 'visible',	//	updated below - track if we're visible
		
		//	update music
		update : function(dt)
		{
			//	app visibility is handled through events, so while hidden, don't update.
			if (audio.visibility === 'hidden')
				return;
			
			//	if somehow this is expensive, then maybe only check every second or so, with a timer?
			audio.musicIsPlaying = rat.audio.isSoundPlaying('music');
			
			var shouldBePlaying = app.settings.musicOn;
			
			if (shouldBePlaying && audio.musicIsPlaying !== true)
			{
				var entry = rat.audio.sounds['music'];
				if (entry)
				{
					var first = entry[0];
					//	rather than ask audio each frame if it's playing,
					//	set a timer to clear our flag when the music is naturally done,
					//	according to its length.
					//	This is wrong for a couple of reasons.
					//	1: it doesn't work?  what?
					//	2: timing may get off somehow, like debugging?
					//	3: we're not stopping/restarting this timeout when music is stopped below...
					//setTimeout(function(){ audio.musicIsPlaying = false; }, first.duration * 1000  );
					audio.playSound('music');
					audio.musicIsPlaying = true;
				}
			}
			else if (!shouldBePlaying && audio.musicIsPlaying === true)
			{
				audio.stopSound('music');
				audio.musicIsPlaying = false;
			}
		},
		
		//	handle visibility change right now...
		//	Do this through events so we can be precise about this unique action
		//	(pausing/resuming sound)
		//	This immediately starts/stops the music track.
		visibilityChange : function(state)
		{
			audio.visibility = state;
			
			//	are we playing?  should we be?
			audio.musicIsPlaying = rat.audio.isSoundPlaying('music');
			var shouldBePlaying = app.settings.musicOn;
			
			if (audio.musicIsPlaying && state === 'hidden')
			{
				//console.log("pausing sound for visibility change");
				rat.audio.pauseSound('music');
			} else if (shouldBePlaying && state === 'visible')
			{
				//	resume
				//console.log("resuming sound for visibility change");
				rat.audio.playSound('music');
			}
		},


	};
	
	//	global access
	window.audio = audio;
});