﻿//
//	game logic and main rendering
//

rat.modules.add( "js.game",
[
	//	dependencies...
	"rat.ui.r_ui",
	
	"js.audio",
	"js.graphics.effects",
	"js.ui.game_screen",
	
	"js.actor",
	"js.data.data",
],
function(rat)
{
	var game = {
		
		//	One-time init per launch.
		oneTimeInit : function()
		{
			
		},
		
		//
		//	init, per level session
		//
		init : function()
		{
			this.state = 'play';
			
			this.buildHud();
			
			this.actors = [];
			this.makeActor();
			
			//	access game data?
			//	game.levels[0].name ...
		},
		
		//
		//	Exit game
		//
		exit : function()
		{
			rat.screenManager.popAllScreens();
			this.hud = null;
		},
		
		//
		//	Set up game HUD/UI
		//	create gamescreen object, which is the HUD overlaid over the game.
		//	see game_screen.js
		//
		buildHud : function()
		{
			var gameScreen = new app.types.GameScreen();
			rat.screenManager.pushScreen(gameScreen);
			this.hud = gameScreen;
		},
		
		//	make an actor
		makeActor : function()
		{
			var a = new app.types.Actor();
			this.actors.push(a);
		},
		
		//	update game (every frame)
		update : function(dt)
		{
			//	does our game's graphics module need to update something every frame?
			gfx.update(dt);
			
			//	update actors (in reverse order in case deleting)
			for (var aIndex = game.actors.length-1; aIndex >= 0; aIndex--)
			{
				var actor = game.actors[aIndex];
				actor.update(dt);
				
				//	want to delete this one?
				//game.actors.splice(aIndex, 1);
			}
		},
		
		//	draw (under UI)
		draw : function(ctx)
		{
			var ctx = ctx;
			ctx.fillStyle = "#FF0000";
			ctx.fillRect(50, 50, 100, 100);
			
			ctx.fillStyle = "#FFFFFF";
			ctx.font = "90px banksiabold";
			ctx.textAlign = "left";
			ctx.fillText("Template Rat Game", 200, 200, 800);
			
			gfx.drawAsset(ctx, 'checkmark', rat.graphics.SCREEN_WIDTH / 2, 300);
			
			//	draw actors
			for (var aIndex = 0; aIndex < game.actors.length; aIndex++)
			{
				var actor = game.actors[aIndex];
				actor.draw(ctx);
			}
		},
		
		//	draw over UI (if needed)
		//postDraw : function(ctx)
		//{
			//ctx.fillStyle = "#101030";
			//ctx.fillRect(0, 0, rat.graphics.SCREEN_WIDTH, rat.graphics.SCREEN_HEIGHT);
		//},
		
		mouseMove : function(pos, ratEvent)
		{
			return true;
		},
		
		mouseDown : function(pos, ratEvent)
		{
			effects.testEffect(pos.x, pos.y);
			audio.playSound('hit');
			
			return true;
		},
		
		mouseUp : function(pos, ratEvent)
		{
			return false;
		},

		handleKeyDown : function(event)
		{
			return false;
		},
		
	};
	
	//	global access
	window.game = game;
	
});