﻿//
//	game screen
//
//	This is the game screen overlay (HUD) that draws on top of game, using rat ui concepts.
//	This module ALSO is a convenient place to hook into events and pass them on to the game,
//	so we do that here.   (clicks, keys, etc.)
//
//	See game.js for game logic and some other more direct drawing code
//

/**
 * @constructor for game screen
 * @extends rat.ui.Screen
*/
rat.modules.add( "js.ui.game_screen",
[
	{name: "rat.ui.r_screen", processBefore: true },	//	we inherit from, so process first.
	"js.ui.ui",	//	we use functions and data here
],
function(rat)
{
	var GameScreen = function()
	{
		GameScreen.prototype.parentConstructor.call(this); //	default init
		
		//	set up this screen
		var screen = this;
		screen.setPos(0, 0);
		screen.setSize(rat.graphics.SCREEN_WIDTH, rat.graphics.SCREEN_HEIGHT);

		//	make title
		//var tbox = ui.makeTitleBox(screen, "[hud]");
		//this.titleBox = tbox;
		//var pos = tbox.getPos();
		
		//	if you want to use the standard ui audio toggle buttons:
		ui.makeAudioButtons(screen);
	};
	(function(){ rat.utils.inheritClassFrom( GameScreen, rat.ui.Screen ); })();

	//
	//	This screen is being activated.
	GameScreen.prototype.myScreenActivate = function()
	{
		//console.log("hud activate");
	}

	//	This screen is being deactivated
	GameScreen.prototype.myScreenDeactivate = function()
	{
		//console.log("hud deactivate");
	}

	//	handle resizing (optional)
	GameScreen.prototype.onWindowResize = function()
	{
		var screen = this;
		//console.log("game screen resize");
		//	In this case, let's try not rebuilding everything.
		//	Let's just adjust the position of a few things.
		
		//	These will only change if we specified autoFillOnResize in graphics setup...
		//	otherwise, no point in handling a resize at all, really...
		//	so, this is all just sample code, really.
		var w = rat.graphics.SCREEN_WIDTH;
		var h = rat.graphics.SCREEN_HEIGHT;
		screen.setSize(w, h);
		
		//	rebuild stuff?
		
		//	rebuild audio buttons to position correctly
		ui.repositionAudioButtons(screen);
	};

	//	update me
	//GameScreen.prototype.updateSelf = function(dt)
	//{
	//	
	//};

	//	mouse down in me
	//	pass on to game.
	GameScreen.prototype.mouseDown = function(pos, ratEvent)
	{
		//console.log("mouseDown " + pos.x + ", " + pos.y);
		return game.mouseDown(pos, ratEvent);
	};

	//	mouse up in me
	//	pass on to game.
	GameScreen.prototype.mouseUp = function(pos, ratEvent)
	{
		return game.mouseUp(pos, ratEvent);
	};

	//	mouse move in me
	//	pass on to game.
	GameScreen.prototype.mouseMove = function(pos, ratEvent)
	{
		return game.mouseMove(pos, ratEvent);
	};


	//	key down in me
	//	pass on to game.
	GameScreen.prototype.handleKeyDown = function(ratEvent)
	{
		//console.log("keyDown " + ratEvent.which);
		return game.handleKeyDown(ratEvent);
	};

	GameScreen.prototype.handleKeyUp = function(ratEvent)
	{
		//return game.handleKeyUp(ratEvent);
	};
	
	app.types.GameScreen = GameScreen;	//	global access to this class for my convenience
});
