﻿//
//	main menu screen
//

/**
 * @constructor for main menu screen
 * @extends rat.ui.Screen
*/
rat.modules.add( "js.ui.main_menu",
[
	{name: "rat.ui.r_screen", processBefore: true },	//	we inherit from, so process first.
	"js.ui.ui",	//	we use functions and data here
],
function(rat)
{
	//	constructor for menu
	var MainMenu = function()
	{
		MainMenu.prototype.parentConstructor.call(this); //	default init
		
		//	set up this screen
		var screen = this;
		screen.setPos(0, 0);
		screen.setSize(rat.graphics.SCREEN_WIDTH, rat.graphics.SCREEN_HEIGHT);

		//	TEMPLATE stuff below
		//		there are lots of ways to create a ui elements like buttons and text in a screen.
		//		In this case we've set up this ui.js module to create them on the fly,
		//		so let's use that.
		
		//	make title
		var tbox = ui.makeTitleBox(screen, "Main Menu");
		this.titleBox = tbox;
		var pos = tbox.getPos();
		
		//	make sample image (e.g. background image)
		var sprite = new rat.ui.Sprite(screen);
		sprite.loadImage("images/checkmark.png");
		sprite.setPos(0,0);
		sprite.setSize(rat.graphics.SCREEN_WIDTH, rat.graphics.SCREEN_HEIGHT);
		
		//	make a button.
		var x = (rat.graphics.SCREEN_WIDTH * 0.5)|0;
		var y = (rat.graphics.SCREEN_HEIGHT * 0.8)|0;
		var button = ui.makeButtonAt(screen, "Play", x, y);
		ui.applyTooltip(button, "Begin a new game");
		button.setCallback(function(e) {
			app.gotoScreen('game');
		});
		
		//	if you want to use the standard ui audio toggle buttons:
		ui.makeAudioButtons(screen);
	};
	(function(){ rat.utils.inheritClassFrom( MainMenu, rat.ui.Screen ); })();

	//
	//	This screen is being activated.
	MainMenu.prototype.myScreenActivate = function()
	{
		//console.log("main menu activate");
	}

	//	This screen is being deactivated
	MainMenu.prototype.myScreenDeactivate = function()
	{
		//console.log("main menu deactivate");
	}

	//	update me
	//MainMenu.prototype.updateSelf = function(dt)
	//{
	//	
	//};

	//	key down in me - behave uniquely here?
	MainMenu.prototype.handleKeyDown = function(ratEvent)
	{
		//console.log("keyDown " + ratEvent.which);
	};

	//	handle resizing (optional)
	/*
	MainMenu.prototype.onWindowResize = function()
	{
		var screen = this;
		//console.log("main menu resize");
		//	In this case, let's try not rebuilding everything.
		//	Let's just adjust the position of a few things.
		
		//	These will only change if we specified autoFillOnResize in graphics setup...
		//	otherwise, no point in handling a resize at all, really...
		//	so, this is all just sample code, really.
		var w = rat.graphics.SCREEN_WIDTH;
		var h = rat.graphics.SCREEN_HEIGHT;
		screen.setSize(w, h);
		
		//	rebuild stuff?
		
		//	rebuild audio buttons to position correctly
		ui.repositionAudioButtons(screen);
	};
	*/
	
	app.types.MainMenu = MainMenu;	//	global access to this class for my convenience
});
